/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.handler;

import cloud.lemonslice.teastory.config.ServerConfig;
import cloud.lemonslice.teastory.handler.event.AgricultureEventHandler;
import cloud.lemonslice.teastory.handler.event.BattleEventHandler;
import cloud.lemonslice.teastory.handler.event.BlockEventHandler;
import cloud.lemonslice.teastory.handler.event.DrinkEffectEventHandler;
import java.io.IOException;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="teastory")
public final class CommonEventHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        DrinkEffectEventHandler.applyAgilityEffect(event);
        DrinkEffectEventHandler.applyDefenceEffect((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DrinkEffectEventHandler.applyLifeDrainEffect(event);
        DrinkEffectEventHandler.applyDefenceEffect((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        DrinkEffectEventHandler.applyExcitementEffect(event);
    }

    @SubscribeEvent
    public static void onUseBoneMeal(BonemealEvent event) {
        AgricultureEventHandler.boneMealUsingLimit(event);
    }

    @SubscribeEvent
    public static void onNeighborChanged(BlockEvent.NeighborNotifyEvent event) {
        BlockEventHandler.dropAsh(event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)ServerConfig.Agriculture.betterMelon.get()).booleanValue()) {
            AgricultureEventHandler.plantMelon(event);
        }
        AgricultureEventHandler.cutMelon(event);
    }

    @SubscribeEvent
    public static void onToolUsing(BlockEvent.BlockToolModificationEvent event) {
        AgricultureEventHandler.onAqueductShovelUsing(event);
    }

    @SubscribeEvent
    public static void onFarmlandTrampled(BlockEvent.FarmlandTrampleEvent event) {
        AgricultureEventHandler.stopTramplingMelonField(event);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        try {
            BattleEventHandler.onShennongChiAttack(event);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

